{********************************************
; File: ADB.p
;
;
; Copyright Apple Computer, Inc. 1986-90
; All Rights Reserved
;
********************************************}

UNIT ADB;
INTERFACE
USES TYPES;
CONST


{ Error Codes }
cmndIncomplete = $0910;  { Command not completed. }
cantSync = $0911;  { Can't synchronize }
adbBusy = $0982;  { Busy  (command pending) }
devNotAtAddr = $0983;  { Device not present at address }
srqListFull = $0984;  { List full }

{ ReadKeyMicroData Codes }
readModes = $000A;
readConfig = $000B;
readADBError = $000C;
readVersionNum = $000D;
readAvailCharSet = $000E;
readAvailLayout = $000F;

{ SendInfo Commands }
abortKbd = $0001;
resetKbd = $0002;
flushKbd = $0003;
setModes = $0004;  { 2nd param is pointer to mode byte }
clearModes = $0005;  { 2nd param is pointer to mode Byte }
setConfig = $0006;  { 2nd param is pointer to SetConfigRec }
synch = $0007;  { 2nd param is pointer to SynchRec }
writeMicroMem = $0008;  { 2nd param is pointer to MicroControlMemRec }
resetSys = $0010;
keyCode = $0011;  { 2nd param is pointer to key code byte. }
resetADB = $0040;
transmitADBBytes = $0047;  { add number of bytes to this  }
enableSRQ = $0050;  { ADB address in low nibble }
flushADBDevBuf = $0060;  { ADB address in low nibble }
disableSRQ = $0070;  { ADB address in low nibble }
transmit2ADBBytes = $0080;  { add ADB address to this }
listen = $0080;  { adbCommand = listen + ( 16 * reg) + (adb address) }
talk = $00C0;  { adbCommand = talk + ( 16 * reg) + (adb address) }

{ Other Constants }
readMicroMem = $0009;

TYPE
ReadConfigRecPtr = ^ReadConfigRec;
ReadConfigRec = PACKED RECORD
    rcADBAddr : Byte; { Output Byte: ADB address - keyboard and mouse }
    rcLayoutOrLang : Byte; { Output Byte: Layout / Language }
    rcRepeatDelay : Byte; { Output Byte: Repeat / Delay }
END;
SetConfigRecPtr = ^SetConfigRec;
SetConfigRec = PACKED RECORD
    scADBAddr : Byte; { keyboard and mouse }
    scLayoutOrLang : Byte;
    scRepeatDelay : Byte;
END;
SynchRecPtr = ^SynchRec;
SynchRec = PACKED RECORD
    synchMode : Byte;
    synchKybdMouseAddr : Byte;
    synchLayoutOrLang : Byte;
    synchRepeatDelay : Byte;
END;
ScaleRecPtr = ^ScaleRec;
ScaleRec = RECORD
    xDivide : Integer;
    yDivide : Integer;
    xOffset : Integer;
    yOffset : Integer;
    xMultiply : Integer;
    yMultiply : Integer;
END;
PROCEDURE AbsOff   ;
PROCEDURE AbsOn   ;
PROCEDURE ADBBootInit   ;
PROCEDURE ADBReset   ;
PROCEDURE ADBShutDown   ;
PROCEDURE ADBStartUp   ;
FUNCTION ADBStatus  : Boolean ;
FUNCTION ADBVersion  : Integer ;
PROCEDURE AsyncADBReceive ( compPtr:Ptr; adbCommand:Integer)  ;
PROCEDURE ClearSRQTable   ;
PROCEDURE GetAbsScale (VAR dataInPtr:ScaleRec)  ;
FUNCTION ReadAbs  : Integer ;
PROCEDURE ReadKeyMicroData ( dataLength:Integer; dataPtr:Ptr; adbCommand:Integer)  ;
PROCEDURE ReadKeyMicroMemory ( dataOutPtr:Ptr; dataInPtr:Ptr; adbCommand:Integer)  ;
PROCEDURE SendInfo ( dataLength:Integer; dataPtr:Ptr; adbCommand:Integer)  ;
PROCEDURE SetAbsScale ( dataOutPtr:ScaleRec)  ;
PROCEDURE SRQPoll ( compPtr:Ptr; adbRegAddr:Integer)  ;
PROCEDURE SRQRemove ( adbRegAddr:Integer)  ;
PROCEDURE SyncADBReceive ( inputWord:Integer; compPtr:Ptr; adbCommand:Integer)  ;
IMPLEMENTATION
END.
